<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    
    <!-- SEO Meta Tags -->
    <title><?php echo isset($meta_title) ? $meta_title . ' - ' : ''; ?><?php echo $site_settings['site_name'] ?? 'NGO Platform'; ?></title>
    <meta name="description" content="<?php echo $meta_description ?? ''; ?>">
    <meta name="keywords" content="<?php echo $meta_keywords ?? ''; ?>">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:title" content="<?php echo $meta_title ?? $site_settings['site_name'] ?? 'NGO Platform'; ?>">
    <meta property="og:description" content="<?php echo $meta_description ?? ''; ?>">
    <?php if (isset($meta_image)): ?>
        <meta property="og:image" content="<?php echo $meta_image; ?>">
    <?php endif; ?>
    
    <!-- Twitter -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?php echo $meta_title ?? $site_settings['site_name'] ?? 'NGO Platform'; ?>">
    <meta name="twitter:description" content="<?php echo $meta_description ?? ''; ?>">
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="<?php echo base_url('assets/images/favicon.ico'); ?>">
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Custom CSS -->
    <style>
        :root {
            --primary-color: #f26124;
            --secondary-color: #231f20;
            --accent-1: #f7e1b0;
            --accent-2: #8105bf;
            --light-bg: #f8f9fa;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            color: var(--secondary-color);
            line-height: 1.6;
        }
        
        /* Navbar */
        .navbar {
            background: white;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            padding: 1rem 0;
        }
        
        .navbar-brand {
            font-size: 1.5rem;
            font-weight: 700;
            color: var(--primary-color) !important;
        }
        
        .nav-link {
            color: var(--secondary-color) !important;
            font-weight: 500;
            padding: 0.5rem 1rem !important;
            transition: color 0.3s;
        }
        
        .nav-link:hover {
            color: var(--primary-color) !important;
        }
        
        .nav-link.active {
            color: var(--primary-color) !important;
        }
        
        .btn-primary {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
            font-weight: 600;
            padding: 0.6rem 1.5rem;
            border-radius: 50px;
            transition: all 0.3s;
        }
        
        .btn-primary:hover {
            background-color: #d94f15;
            border-color: #d94f15;
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(242, 97, 36, 0.3);
        }
        
        .btn-outline-primary {
            color: var(--primary-color);
            border-color: var(--primary-color);
            font-weight: 600;
            padding: 0.6rem 1.5rem;
            border-radius: 50px;
            transition: all 0.3s;
        }
        
        .btn-outline-primary:hover {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
            transform: translateY(-2px);
        }
        
        /* Page Header */
        .page-header {
            background: linear-gradient(135deg, var(--primary-color), var(--accent-2));
            color: white;
            padding: 4rem 0 3rem;
            margin-bottom: 3rem;
        }
        
        .page-header h1 {
            font-size: 2.5rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
        }
        
        .page-header p {
            font-size: 1.1rem;
            opacity: 0.95;
        }
        
        /* Breadcrumbs */
        .breadcrumb {
            background: transparent;
            padding: 0;
            margin-top: 1rem;
        }
        
        .breadcrumb-item a {
            color: white;
            text-decoration: none;
        }
        
        .breadcrumb-item.active {
            color: rgba(255,255,255,0.8);
        }
        
        /* Footer */
        footer {
            background: var(--secondary-color);
            color: white;
            padding: 3rem 0 1rem;
            margin-top: 5rem;
        }
        
        footer a {
            color: white;
            text-decoration: none;
            transition: color 0.3s;
        }
        
        footer a:hover {
            color: var(--primary-color);
        }
        
        .footer-title {
            color: var(--primary-color);
            font-weight: 600;
            margin-bottom: 1rem;
        }
        
        .social-links a {
            display: inline-block;
            width: 40px;
            height: 40px;
            line-height: 40px;
            text-align: center;
            background: rgba(255,255,255,0.1);
            border-radius: 50%;
            margin-right: 10px;
            transition: all 0.3s;
        }
        
        .social-links a:hover {
            background: var(--primary-color);
            transform: translateY(-3px);
        }
        
        /* Flash Messages */
        .flash-message {
            position: fixed;
            top: 80px;
            right: 20px;
            z-index: 9999;
            min-width: 300px;
            max-width: 500px;
            animation: slideIn 0.3s ease-out;
        }
        
        @keyframes slideIn {
            from {
                transform: translateX(400px);
                opacity: 0;
            }
            to {
                transform: translateX(0);
                opacity: 1;
            }
        }
        
        /* Utilities */
        .text-primary {
            color: var(--primary-color) !important;
        }
        
        .bg-primary {
            background-color: var(--primary-color) !important;
        }
        
        .bg-light-primary {
            background-color: rgba(242, 97, 36, 0.1);
        }
        
        /* Responsive */
        @media (max-width: 768px) {
            .page-header h1 {
                font-size: 2rem;
            }
            
            .page-header p {
                font-size: 1rem;
            }
        }
    </style>
</head>
<body>
    
    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-light sticky-top">
        <div class="container">
           <a class="navbar-brand" href="<?php echo base_url(); ?>">
				<img src="<?php echo base_url('assets/images/logo.png'); ?>" alt="Logo" height="40">
			</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($this->uri->segment(1) == '' || $this->uri->segment(1) == 'home') ? 'active' : ''; ?>" 
                           href="<?php echo base_url(); ?>">Home</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($this->uri->segment(1) == 'about') ? 'active' : ''; ?>" 
                           href="<?php echo base_url('about'); ?>">About</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($this->uri->segment(1) == 'workshops') ? 'active' : ''; ?>" 
                           href="<?php echo base_url('workshops'); ?>">Workshops</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($this->uri->segment(1) == 'blog') ? 'active' : ''; ?>" 
                           href="<?php echo base_url('blog'); ?>">Blog</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($this->uri->segment(1) == 'volunteer') ? 'active' : ''; ?>" 
                           href="<?php echo base_url('volunteer/apply'); ?>">Volunteer</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($this->uri->segment(1) == 'contact') ? 'active' : ''; ?>" 
                           href="<?php echo base_url('contact'); ?>">Contact</a>
                    </li>
                    <li class="nav-item">
                        <a class="btn btn-primary ms-2" href="<?php echo base_url('donate'); ?>">
                            <i class="fas fa-heart"></i> Donate
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Flash Messages -->
    <?php if ($this->session->flashdata('success')): ?>
        <div class="flash-message">
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="fas fa-check-circle"></i> <?php echo $this->session->flashdata('success'); ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        </div>
    <?php endif; ?>
    
    <?php if ($this->session->flashdata('error')): ?>
        <div class="flash-message">
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="fas fa-exclamation-circle"></i> <?php echo $this->session->flashdata('error'); ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        </div>
    <?php endif; ?>
    
    <?php if ($this->session->flashdata('warning')): ?>
        <div class="flash-message">
            <div class="alert alert-warning alert-dismissible fade show" role="alert">
                <i class="fas fa-exclamation-triangle"></i> <?php echo $this->session->flashdata('warning'); ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        </div>
    <?php endif; ?>
    
    <?php if ($this->session->flashdata('info')): ?>
        <div class="flash-message">
            <div class="alert alert-info alert-dismissible fade show" role="alert">
                <i class="fas fa-info-circle"></i> <?php echo $this->session->flashdata('info'); ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        </div>
    <?php endif; ?>

    <!-- Page Header (if not disabled) -->
    <?php if (!isset($disable_page_header) || !$disable_page_header): ?>
        <?php if (isset($page_title) && $page_title): ?>
            <div class="page-header">
                <div class="container">
                    <h1><?php echo $page_title; ?></h1>
                    <?php if (isset($page_subtitle) && $page_subtitle): ?>
                        <p class="lead"><?php echo $page_subtitle; ?></p>
                    <?php endif; ?>
                    
                    <?php if (!empty($breadcrumbs)): ?>
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <?php foreach ($breadcrumbs as $crumb): ?>
                                    <?php if ($crumb['url']): ?>
                                        <li class="breadcrumb-item">
                                            <a href="<?php echo $crumb['url']; ?>"><?php echo $crumb['title']; ?></a>
                                        </li>
                                    <?php else: ?>
                                        <li class="breadcrumb-item active"><?php echo $crumb['title']; ?></li>
                                    <?php endif; ?>
                                <?php endforeach; ?>
                            </ol>
                        </nav>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
    <?php endif; ?>

    <!-- Main Content -->
    <main>
        <?php echo $content_for_layout; ?>
    </main>

    <!-- Footer -->
    <footer>
        <div class="container">
            <div class="row">
                <!-- About Section -->
                <div class="col-lg-4 col-md-6 mb-4">
                    <h5 class="footer-title">About Us</h5>
                    <p><?php echo character_limiter($site_settings['about_description'] ?? 'Making a positive impact in our community.', 150); ?></p>
                    
                    <?php if (!empty($site_settings['facebook_url']) || !empty($site_settings['twitter_url']) || 
                              !empty($site_settings['instagram_url']) || !empty($site_settings['linkedin_url'])): ?>
                        <div class="social-links mt-3">
                            <?php if (!empty($site_settings['facebook_url'])): ?>
                                <a href="<?php echo $site_settings['facebook_url']; ?>" target="_blank" rel="noopener">
                                    <i class="fab fa-facebook-f"></i>
                                </a>
                            <?php endif; ?>
                            <?php if (!empty($site_settings['twitter_url'])): ?>
                                <a href="<?php echo $site_settings['twitter_url']; ?>" target="_blank" rel="noopener">
                                    <i class="fab fa-twitter"></i>
                                </a>
                            <?php endif; ?>
                            <?php if (!empty($site_settings['instagram_url'])): ?>
                                <a href="<?php echo $site_settings['instagram_url']; ?>" target="_blank" rel="noopener">
                                    <i class="fab fa-instagram"></i>
                                </a>
                            <?php endif; ?>
                            <?php if (!empty($site_settings['linkedin_url'])): ?>
                                <a href="<?php echo $site_settings['linkedin_url']; ?>" target="_blank" rel="noopener">
                                    <i class="fab fa-linkedin-in"></i>
                                </a>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
                
                <!-- Quick Links -->
                <div class="col-lg-2 col-md-6 mb-4">
                    <h5 class="footer-title">Quick Links</h5>
                    <ul class="list-unstyled">
                        <li class="mb-2"><a href="<?php echo base_url(); ?>">Home</a></li>
                        <li class="mb-2"><a href="<?php echo base_url('about'); ?>">About Us</a></li>
                        <li class="mb-2"><a href="<?php echo base_url('workshops'); ?>">Workshops</a></li>
                        <li class="mb-2"><a href="<?php echo base_url('blog'); ?>">Blog</a></li>
                        <li class="mb-2"><a href="<?php echo base_url('partners'); ?>">Partners</a></li>
                    </ul>
                </div>
                
                <!-- Get Involved -->
                <div class="col-lg-3 col-md-6 mb-4">
                    <h5 class="footer-title">Get Involved</h5>
                    <ul class="list-unstyled">
                        <li class="mb-2"><a href="<?php echo base_url('volunteer/apply'); ?>">Become a Volunteer</a></li>
                        <li class="mb-2"><a href="<?php echo base_url('consultation'); ?>">Free Consultation</a></li>
                        <li class="mb-2"><a href="<?php echo base_url('donate'); ?>">Donate</a></li>
                        <li class="mb-2"><a href="<?php echo base_url('contact'); ?>">Contact Us</a></li>
                    </ul>
                </div>
                
                <!-- Contact Info -->
                <div class="col-lg-3 col-md-6 mb-4">
                    <h5 class="footer-title">Contact Info</h5>
                    <ul class="list-unstyled">
                        <?php if (!empty($site_settings['site_email'])): ?>
                            <li class="mb-2">
                                <i class="fas fa-envelope me-2"></i>
                                <a href="mailto:<?php echo $site_settings['site_email']; ?>">
                                    <?php echo $site_settings['site_email']; ?>
                                </a>
                            </li>
                        <?php endif; ?>
                        
                        <?php if (!empty($site_settings['site_phone'])): ?>
                            <li class="mb-2">
                                <i class="fas fa-phone me-2"></i>
                                <a href="tel:<?php echo $site_settings['site_phone']; ?>">
                                    <?php echo $site_settings['site_phone']; ?>
                                </a>
                            </li>
                        <?php endif; ?>
                        
                        <?php if (!empty($site_settings['site_address'])): ?>
                            <li class="mb-2">
                                <i class="fas fa-map-marker-alt me-2"></i>
                                <?php echo $site_settings['site_address']; ?>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
            
            <hr style="border-color: rgba(255,255,255,0.1);">
            
            <!-- Copyright -->
            <div class="row">
                <div class="col-md-6 text-center text-md-start mb-2">
                    <p class="mb-0">&copy; <?php echo date('Y'); ?> <?php echo $site_settings['site_name'] ?? 'NGO Platform'; ?>. All Rights Reserved.</p>
                </div>
                <div class="col-md-6 text-center text-md-end">
                    <a href="<?php echo base_url('privacy'); ?>" class="me-3">Privacy Policy</a>
                    <a href="<?php echo base_url('terms'); ?>">Terms & Conditions</a>
                </div>
            </div>
        </div>
    </footer>

    <!-- Bootstrap 5 JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Auto-hide flash messages -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            setTimeout(function() {
                var alerts = document.querySelectorAll('.flash-message .alert');
                alerts.forEach(function(alert) {
                    var bsAlert = new bootstrap.Alert(alert);
                    bsAlert.close();
                });
            }, 5000);
        });
    </script>
</body>
</html>